-- This script opens a browser where you can select a file to load all files
-- in that folderpath into the mtl_api and create material with them.

-- The function 'mtl_api.set_textures' has a parameter 'setChannels:' (by default = true). When set to true 
-- it also automatically loads the textures into a channel, by use of active namingFilters. 
-- Use 'mtl_api.get_nameFilters()' to see which ones are active and 'mtl_api.available_nameFilters()' which are available.

-- You can manually set channel textures, by using 'mtl_api.set_channel_texture <channelname> <<textureFilePath>'
-- when you set a channel_texture to 'undefined' it will remove the texture from that channel.
-- 'mtl_api.available_channels()' shows all channel names.

-- "Default" preset sets the mapType and materialType to "Render", which will create a material for the active renderer.

(
	local selectedFile 	 = getOpenFileName()
	local selectedFolder = getFilenamePath selectedFile
	local folderFiles 	 = getfiles (selectedFolder+"*")
	--
	mtl_api.close()										-- closes the MTL rollout menu
														-- this can be done to speed up material creation
	--
	mtl_api.clear()										-- clears textures, channels and material
	--
	mtl_api.set_preset "Default" 						-- loads the default MTL settings
	mtl_api.set_nameFilters #("02_Short Forms") 		-- sets namingFilter '02_Short Forms' active
	mtl_api.set_textures folderFiles 					-- loads textures and set channel textures
	--
	--mtl_api.set_channel_texture "diffuse" undefined 	-- clears the diffuse channel texture
	--
	mtl_api.create_material() 							-- creates a new material
	mtl_api.addToSlate view:2 							-- add created material to view 2 of the Slate Material Editor
)